import math
import pygame
from raycaster import FOV, HALF_HEIGHT, WIDTH, PROJ_COEFF

class Projectile:
    def __init__(self, x, y, angle, speed=0.1, color=(255, 120, 0)):
        # Start slightly in front of player to avoid immediate collision
        self.x = x + math.cos(angle) * 0.3
        self.y = y + math.sin(angle) * 0.3
        self.angle = angle
        self.speed = speed
        self.color = color
        self.alive = True
        self.radius = 0.12

    def update(self, world,nil):
        if not self.alive:
            return

        nx = math.cos(self.angle) * self.speed
        ny = math.sin(self.angle) * self.speed

        # Check collision before moving
        new_x = self.x + nx
        new_y = self.y + ny

        if (int(new_x), int(new_y)) in world.map:
            self.alive = False
            return

        self.x = new_x
        self.y = new_y

    def draw(self, screen, player):
        dx = self.x - player.x
        dy = self.y - player.y
        distance = math.hypot(dx, dy)

        angle_to_player = math.atan2(dy, dx) - player.angle
        angle_to_player = (angle_to_player + math.tau) % math.tau
        if angle_to_player > math.pi:
            angle_to_player -= math.tau

        if abs(angle_to_player) > FOV:
            return

        screen_x = (angle_to_player / FOV + 0.5) * WIDTH
        proj_size = min(PROJ_COEFF / (distance + 0.0001), 80)  # larger for visibility
        top = HALF_HEIGHT - proj_size // 2

        pygame.draw.rect(
            screen,
            self.color,
            (screen_x - proj_size // 2, top, proj_size, proj_size)
        )
